/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.enhance;

import jakarta.persistence.spi.TransformerException;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.hibernate.bytecode.enhance.internal.bytebuddy.CorePrefixFilter;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementContextWrapper;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.internal.BytecodeProviderInitiator;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.bytecode.spi.ClassTransformer;

public class EnhancingClassTransformerImpl
implements ClassTransformer {
    private final EnhancementContext enhancementContext;
    private final BytecodeProvider bytecodeProvider;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile WeakReference<Entry> entryReference;

    public EnhancingClassTransformerImpl(EnhancementContext enhancementContext) {
        Objects.requireNonNull(enhancementContext);
        this.enhancementContext = enhancementContext;
        BytecodeProvider overriddenProvider = enhancementContext.getBytecodeProvider();
        this.bytecodeProvider = overriddenProvider == null ? BytecodeProviderInitiator.buildDefaultBytecodeProvider() : overriddenProvider;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws TransformerException {
        String classNameDotFormat = className.replace('/', '.');
        if (CorePrefixFilter.DEFAULT_INSTANCE.isCoreClassName(classNameDotFormat)) {
            return null;
        }
        try {
            byte[] byArray = this.getEnhancer(loader).enhance(className, classfileBuffer);
            return byArray;
        }
        catch (Exception e) {
            throw new TransformerException("Error performing enhancement of " + className, (Throwable)e);
        }
        finally {
            this.bytecodeProvider.resetCaches();
        }
    }

    @Override
    public void discoverTypes(ClassLoader loader, String className) {
        this.getEnhancer(loader).discoverTypes(className, null);
    }

    private Enhancer getEnhancer(ClassLoader loader) {
        Entry enhancerEntry = EnhancingClassTransformerImpl.getEnhancerEntry(this.entryReference, loader);
        if (enhancerEntry == null) {
            this.lock.lock();
            try {
                enhancerEntry = EnhancingClassTransformerImpl.getEnhancerEntry(this.entryReference, loader);
                if (enhancerEntry == null) {
                    enhancerEntry = new Entry(loader, this.createEnhancer(loader));
                    this.entryReference = new WeakReference<Entry>(enhancerEntry);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return enhancerEntry.enhancer;
    }

    private static Entry getEnhancerEntry(WeakReference<Entry> weakReference, ClassLoader loader) {
        if (weakReference == null) {
            return null;
        }
        Entry entry = (Entry)weakReference.get();
        if (entry == null || entry.classLoader != loader) {
            return null;
        }
        return entry;
    }

    private Enhancer createEnhancer(ClassLoader loader) {
        return this.bytecodeProvider.getEnhancer(new EnhancementContextWrapper(this.enhancementContext, loader));
    }

    private static class Entry {
        final ClassLoader classLoader;
        final Enhancer enhancer;

        public Entry(ClassLoader classLoader, Enhancer enhancer) {
            this.classLoader = classLoader;
            this.enhancer = enhancer;
        }
    }
}

