/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.integration.annotation.EndpointId;
import org.springframework.integration.annotation.Role;
import org.springframework.integration.config.annotation.MethodAnnotationPostProcessor;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class MessagingAnnotationBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
SmartInitializingSingleton {
    private final Set<Class<?>> noAnnotationsCache = Collections.newSetFromMap(new ConcurrentHashMap(256));
    private final Map<Class<? extends Annotation>, MethodAnnotationPostProcessor<?>> postProcessors;
    private final List<Runnable> methodsToPostProcessAfterContextInitialization = new ArrayList<Runnable>();
    private ConfigurableListableBeanFactory beanFactory;
    private volatile boolean initialized;

    public MessagingAnnotationBeanPostProcessor(Map<Class<? extends Annotation>, MethodAnnotationPostProcessor<?>> postProcessors) {
        this.postProcessors = postProcessors;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Assert.notNull((Object)this.beanFactory, (String)"BeanFactory must not be null");
        Class beanClass = AopUtils.getTargetClass((Object)bean);
        if (this.noAnnotationsCache.contains(beanClass)) {
            return bean;
        }
        ReflectionUtils.doWithMethods((Class)beanClass, method -> this.doWithMethod(method, bean, beanName, beanClass), (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        return bean;
    }

    private void doWithMethod(Method method, Object bean, String beanName, Class<?> beanClass) {
        MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)method);
        boolean noMessagingAnnotations = true;
        if (!mergedAnnotations.isPresent(Bean.class)) {
            List<MessagingMetaAnnotation> messagingAnnotations = MessagingAnnotationBeanPostProcessor.obtainMessagingAnnotations(this.postProcessors.keySet(), mergedAnnotations, method.toGenericString());
            for (MessagingMetaAnnotation messagingAnnotation : messagingAnnotations) {
                noMessagingAnnotations = false;
                Class<? extends Annotation> annotationType = messagingAnnotation.annotationType;
                List<Annotation> annotationChain = MessagingAnnotationUtils.getAnnotationChain(messagingAnnotation.annotation, annotationType);
                this.processAnnotationTypeOnMethod(bean, beanName, method, annotationType, annotationChain);
            }
        }
        if (noMessagingAnnotations) {
            this.noAnnotationsCache.add(beanClass);
        }
    }

    private void processAnnotationTypeOnMethod(Object bean, String beanName, Method method, Class<? extends Annotation> annotationType, List<Annotation> annotations) {
        MethodAnnotationPostProcessor<?> postProcessor = this.postProcessors.get(annotationType);
        if (postProcessor != null && postProcessor.supportsPojoMethod() && postProcessor.shouldCreateEndpoint(method, annotations)) {
            Method targetMethod = method;
            if (AopUtils.isJdkDynamicProxy((Object)bean)) {
                try {
                    targetMethod = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Service methods must be extracted to the service interface for JdkDynamicProxy. The affected bean is: '" + beanName + "' and its method: '" + String.valueOf(method) + "'", e);
                }
            }
            if (this.initialized) {
                this.postProcessMethodAndRegisterEndpointIfAny(bean, beanName, method, annotationType, annotations, postProcessor, targetMethod);
            } else {
                Method methodToPostProcess = targetMethod;
                this.methodsToPostProcessAfterContextInitialization.add(() -> this.postProcessMethodAndRegisterEndpointIfAny(bean, beanName, method, annotationType, annotations, postProcessor, methodToPostProcess));
            }
        }
    }

    private void postProcessMethodAndRegisterEndpointIfAny(Object bean, String beanName, Method method, Class<? extends Annotation> annotationType, List<Annotation> annotations, MethodAnnotationPostProcessor<?> postProcessor, Method targetMethod) {
        Object result = postProcessor.postProcess(bean, beanName, targetMethod, annotations);
        if (result instanceof AbstractEndpoint) {
            Role role;
            String phase;
            AbstractEndpoint endpoint = (AbstractEndpoint)result;
            String autoStartup = MessagingAnnotationUtils.resolveAttribute(annotations, "autoStartup", String.class);
            if (StringUtils.hasText((String)autoStartup) && StringUtils.hasText((String)(autoStartup = this.beanFactory.resolveEmbeddedValue(autoStartup)))) {
                endpoint.setAutoStartup(Boolean.parseBoolean(autoStartup));
            }
            if (StringUtils.hasText((String)(phase = MessagingAnnotationUtils.resolveAttribute(annotations, "phase", String.class))) && StringUtils.hasText((String)(phase = this.beanFactory.resolveEmbeddedValue(phase)))) {
                endpoint.setPhase(Integer.parseInt(phase));
            }
            if ((role = (Role)AnnotationUtils.findAnnotation((Method)method, Role.class)) != null) {
                endpoint.setRole(role.value());
            }
            String endpointBeanName = this.generateBeanName(beanName, method, annotationType);
            endpoint.setBeanName(endpointBeanName);
            ((BeanDefinitionRegistry)this.beanFactory).registerBeanDefinition(endpointBeanName, (BeanDefinition)new RootBeanDefinition(endpoint.getClass(), () -> endpoint));
            this.beanFactory.getBean(endpointBeanName);
        }
    }

    protected String generateBeanName(String originalBeanName, Method method, Class<? extends Annotation> annotationType) {
        Object name = MessagingAnnotationUtils.endpointIdValue(method);
        if (!StringUtils.hasText((String)name)) {
            String baseName = originalBeanName + "." + method.getName() + "." + ClassUtils.getShortNameAsProperty(annotationType);
            name = baseName;
            int count = 1;
            while (this.beanFactory.containsBean((String)name)) {
                name = baseName + "#" + ++count;
            }
        }
        return name;
    }

    public void afterSingletonsInstantiated() {
        this.initialized = true;
        this.methodsToPostProcessAfterContextInitialization.forEach(Runnable::run);
        this.methodsToPostProcessAfterContextInitialization.clear();
    }

    protected static List<MessagingMetaAnnotation> obtainMessagingAnnotations(Set<Class<? extends Annotation>> postProcessors, MergedAnnotations annotations, String identified) {
        ArrayList<MessagingMetaAnnotation> messagingAnnotations = new ArrayList<MessagingMetaAnnotation>();
        for (Class<? extends Annotation> annotationType : postProcessors) {
            annotations.stream().filter(ann -> ann.getType().equals(annotationType)).map(MergedAnnotation::getRoot).map(MergedAnnotation::synthesize).map(ann -> new MessagingMetaAnnotation((Annotation)ann, annotationType)).forEach(messagingAnnotations::add);
        }
        if (annotations.get(EndpointId.class, ann -> ann.hasNonDefaultValue("value")).isPresent() && messagingAnnotations.size() > 1) {
            throw new IllegalStateException("@EndpointId on " + identified + " can only have one EIP annotation, found: " + messagingAnnotations.size());
        }
        return messagingAnnotations;
    }

    public record MessagingMetaAnnotation(Annotation annotation, Class<? extends Annotation> annotationType) {
    }
}

