/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.beans.Introspector;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.integration.config.DefaultConfiguringBeanFactoryPostProcessor;
import org.springframework.integration.config.GatewayProxyInstantiationPostProcessor;
import org.springframework.integration.config.IntegrationConfigurationBeanFactoryPostProcessor;
import org.springframework.integration.config.MessagingAnnotationBeanPostProcessor;
import org.springframework.integration.config.MessagingAnnotationPostProcessor;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class IntegrationRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(@Nullable AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        org.springframework.integration.util.ClassUtils.resolvePrimitiveType(Integer.class);
        this.registerDefaultConfiguringBeanFactoryPostProcessor(registry);
        this.registerIntegrationConfigurationBeanFactoryPostProcessor(registry);
        if (importingClassMetadata != null) {
            this.registerMessagingAnnotationPostProcessors(registry);
        }
        this.registerGatewayProxyInstantiationPostProcessor(registry);
    }

    private void registerDefaultConfiguringBeanFactoryPostProcessor(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition("DefaultConfiguringBeanFactoryPostProcessor")) {
            BeanDefinitionBuilder postProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultConfiguringBeanFactoryPostProcessor.class).setRole(2);
            registry.registerBeanDefinition("DefaultConfiguringBeanFactoryPostProcessor", (BeanDefinition)postProcessorBuilder.getBeanDefinition());
        }
    }

    private void registerIntegrationConfigurationBeanFactoryPostProcessor(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition("integrationConfigurationBeanFactoryPostProcessor")) {
            BeanDefinitionBuilder postProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition(IntegrationConfigurationBeanFactoryPostProcessor.class).setRole(2);
            registry.registerBeanDefinition("integrationConfigurationBeanFactoryPostProcessor", (BeanDefinition)postProcessorBuilder.getBeanDefinition());
        }
    }

    private void registerMessagingAnnotationPostProcessors(BeanDefinitionRegistry registry) {
        String beanName;
        if (!registry.containsBeanDefinition("org.springframework.integration.internalMessagingAnnotationPostProcessor")) {
            registry.registerBeanDefinition("org.springframework.integration.internalMessagingAnnotationPostProcessor", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(MessagingAnnotationPostProcessor.class).setRole(2).getBeanDefinition());
        }
        if (!registry.containsBeanDefinition(beanName = Introspector.decapitalize(MessagingAnnotationBeanPostProcessor.class.getName()))) {
            registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition().setFactoryMethodOnBean("messagingAnnotationBeanPostProcessor", "org.springframework.integration.internalMessagingAnnotationPostProcessor").setRole(2).getBeanDefinition());
        }
    }

    private void registerGatewayProxyInstantiationPostProcessor(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition("gatewayProxyBeanDefinitionPostProcessor")) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GatewayProxyInstantiationPostProcessor.class).addConstructorArgValue((Object)registry).setRole(2);
            registry.registerBeanDefinition("gatewayProxyBeanDefinitionPostProcessor", (BeanDefinition)builder.getBeanDefinition());
        }
    }

    static {
        if (ClassUtils.isPresent((String)"org.springframework.integration.dsl.support.Function", null)) {
            throw new ApplicationContextException("Starting with Spring Integration 5.0, the 'spring-integration-java-dsl' dependency is no longer needed; the Java DSL has been merged into the core project. If it is present on the classpath, it will cause class loading conflicts.");
        }
    }
}

